<?php
require_once __DIR__ . '/../config/db.php';
$cfg = app_config();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title><?php echo htmlspecialchars($cfg['APP_NAME']); ?> | Vendor App Backend</title>
  <meta name="description" content="Utile helps vendors manage leads, jobs, earnings, and KYC approvals with a clean workflow."/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg border-bottom">
  <div class="container">
    <a class="navbar-brand fw-bold" href="#"><?php echo htmlspecialchars($cfg['APP_NAME']); ?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link" href="#features">Features</a></li>
        <li class="nav-item"><a class="nav-link" href="#how">How it works</a></li>
        <li class="nav-item"><a class="nav-link" href="admin/login.php">Admin</a></li>
      </ul>
    </div>
  </div>
</nav>

<header class="hero">
  <div class="container">
    <div class="row align-items-center g-4">
      <div class="col-lg-6">
        <div class="badge-soft mb-3">Professional Vendor Workflow • KYC • Leads • Wallet</div>
        <h1 class="display-5 fw-bold">A business-grade backend for your Utile Vendor App</h1>
        <p class="text-secondary mt-3">
          REST APIs + Admin Panel built on PHP & MySQL. Supports OTP demo login, onboarding KYC, lead purchase workflow,
          job lifecycle, wallet transactions, and earnings dashboard.
        </p>
        <div class="d-flex gap-2 mt-4">
          <a class="btn btn-primary btn-lg" href="admin/login.php">Open Admin Panel</a>
          <a class="btn btn-outline-dark btn-lg" href="#contact">Request Demo</a>
        </div>
        <div class="text-muted small mt-3">Theme: Primary #FEF1E4 • Secondary #212222</div>
      </div>
      <div class="col-lg-6">
        <div class="card p-4">
          <h5 class="fw-bold mb-3">Quick API checks</h5>
          <div class="small text-muted mb-2">Base URL: <code><?php echo htmlspecialchars($cfg['BASE_URL']); ?>/api</code></div>
          <ul class="small mb-0">
            <li><code>POST /auth/request-otp</code> (demo OTP: <strong><?php echo htmlspecialchars($cfg['DEMO_OTP']); ?></strong>)</li>
            <li><code>POST /auth/login</code> (phone: <strong>9999999999</strong>)</li>
            <li><code>GET /leads</code> (Bearer token)</li>
            <li><code>POST /leads/{id}/pick</code></li>
            <li><code>POST /jobs/{id}/start</code> (multipart)</li>
            <li><code>POST /jobs/{id}/complete</code> (OTP: <strong><?php echo htmlspecialchars($cfg['COMPLETION_OTP']); ?></strong>)</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</header>

<section id="features" class="section">
  <div class="container">
    <div class="row mb-4">
      <div class="col-lg-7">
        <h2 class="fw-bold">Everything you need for the vendor lifecycle</h2>
        <p class="text-muted">Built to match your app flows: registration, KYC, approval, leads purchase, jobs execution, wallet & earnings.</p>
      </div>
    </div>

    <div class="row g-3">
      <?php
      $features = [
        ['OTP Login & Registration','Demo OTP flow for fast testing; easy to swap to SMS provider later.'],
        ['KYC Onboarding','Upload Aadhaar/PAN/license documents; statuses and admin notes supported.'],
        ['Leads → Jobs','Wallet-based lead purchase; jobs move accepted → in_progress → completed.'],
        ['Wallet & Earnings','Recharge (mocked), debit/credit history, earning credits on completion.'],
        ['Admin Panel','Professional sidebar UI. Manage vendors, approvals, KYC notes, leads, jobs, transactions.'],
        ['Landing Page','Attractive landing page aligned with your brand palette.']
      ];
      foreach ($features as $f) { ?>
        <div class="col-md-6 col-lg-4">
          <div class="card p-4 h-100">
            <div class="feature-icon mb-3">✓</div>
            <h5 class="fw-semibold"><?php echo htmlspecialchars($f[0]); ?></h5>
            <p class="text-muted mb-0"><?php echo htmlspecialchars($f[1]); ?></p>
          </div>
        </div>
      <?php } ?>
    </div>
  </div>
</section>

<section id="how" class="section" style="background:var(--primary);">
  <div class="container">
    <div class="row g-3 align-items-stretch">
      <div class="col-lg-6">
        <div class="card p-4 h-100">
          <h4 class="fw-bold">Vendor Demo Flows</h4>
          <ol class="text-muted">
            <li>Login with phone <strong>9999999999</strong> and OTP <strong><?php echo htmlspecialchars($cfg['DEMO_OTP']); ?></strong></li>
            <li>Register new vendor → submit KYC → login shows Pending Approval</li>
            <li>Pick lead → wallet deducted → job appears in Ongoing</li>
            <li>Start job (before photo) → complete (after photo + OTP <strong><?php echo htmlspecialchars($cfg['COMPLETION_OTP']); ?></strong>)</li>
            <li>Wallet credited with demo earning</li>
          </ol>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="card p-4 h-100">
          <h4 class="fw-bold">Admin Capabilities</h4>
          <ul class="text-muted">
            <li>Create/Edit Vendors (name, phone, email, status, wallet)</li>
            <li>Review KYC docs and write editable approval notes</li>
            <li>Approve/Reject Vendors and KYC</li>
            <li>Manage Leads, Jobs, and Wallet Transactions</li>
          </ul>
          <a class="btn btn-primary mt-2" href="admin/login.php">Go to Admin</a>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="contact" class="section">
  <div class="container">
    <div class="row align-items-center g-4">
      <div class="col-lg-6">
        <h2 class="fw-bold">Contact</h2>
        <p class="text-muted">Send a message. This will be stored in the database (Admin can view from DB).</p>
      </div>
      <div class="col-lg-6">
        <div class="card p-4">
          <form method="post" action="contact.php">
            <div class="row g-2">
              <div class="col-md-6">
                <label class="form-label">Name</label>
                <input name="name" class="form-control" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Email</label>
                <input name="email" type="email" class="form-control" required>
              </div>
              <div class="col-12">
                <label class="form-label">Phone</label>
                <input name="phone" class="form-control">
              </div>
              <div class="col-12">
                <label class="form-label">Message</label>
                <textarea name="message" class="form-control" rows="4" required></textarea>
              </div>
              <div class="col-12 d-flex gap-2 align-items-center">
                <button class="btn btn-primary" type="submit">Send</button>
                <span class="text-muted small">We respond within business hours.</span>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

<footer class="footer">
  <div class="container d-flex justify-content-between align-items-center">
    <div class="small">© <?php echo date('Y'); ?> <?php echo htmlspecialchars($cfg['APP_NAME']); ?></div>
    <div class="small">Powered by PHP & MySQL</div>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
