<?php
$active = 'vendors';
require_once __DIR__ . '/partials/top.php';
$pdo = db();

$q = trim($_GET['q'] ?? '');
$params = [];
$sql = "SELECT * FROM vendors";
if ($q !== '') {
  $sql .= " WHERE name LIKE ? OR phone LIKE ? OR email LIKE ? OR vendor_code LIKE ?";
  $like = "%$q%";
  $params = [$like,$like,$like,$like];
}
$sql .= " ORDER BY created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$vendors = $stmt->fetchAll();

function badge($status) {
  $map = ['approved'=>'success','pending'=>'warning','rejected'=>'danger'];
  $c = $map[$status] ?? 'secondary';
  return "<span class='badge text-bg-$c'>$status</span>";
}
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="fw-bold mb-0">Vendors</h4>
    <div class="text-muted small">Create, edit, approve/reject vendors, and review KYC.</div>
  </div>
  <a class="btn btn-dark" href="vendor_form.php">+ Create Vendor</a>
</div>

<form class="row g-2 mb-3">
  <div class="col-md-6 col-lg-4">
    <input class="form-control" name="q" placeholder="Search by name/phone/email/code" value="<?php echo htmlspecialchars($q); ?>">
  </div>
  <div class="col-auto">
    <button class="btn btn-outline-dark" type="submit">Search</button>
  </div>
</form>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle mb-0">
      <thead>
        <tr>
          <th>Code</th>
          <th>Name</th>
          <th>Phone</th>
          <th>Email</th>
          <th>Approval</th>
          <th>KYC</th>
          <th>Wallet</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($vendors as $v): ?>
          <tr>
            <td class="fw-semibold"><?php echo htmlspecialchars($v['vendor_code']); ?></td>
            <td><?php echo htmlspecialchars($v['name']); ?></td>
            <td><?php echo htmlspecialchars($v['phone']); ?></td>
            <td><?php echo htmlspecialchars($v['email'] ?? '-'); ?></td>
            <td><?php echo badge($v['approval_status']); ?> <?php if ((int)$v['is_active']===1) echo "<span class='badge text-bg-dark ms-1'>active</span>"; ?></td>
            <td><?php echo badge($v['kyc_status']); ?></td>
            <td>₹<?php echo (int)$v['wallet_balance']; ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-dark" href="vendor_form.php?id=<?php echo (int)$v['id']; ?>">Edit</a>
              <a class="btn btn-sm btn-dark" href="vendor_view.php?id=<?php echo (int)$v['id']; ?>">KYC / Approve</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($vendors)===0): ?>
          <tr><td colspan="8" class="text-muted">No vendors found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/partials/bottom.php'; ?>
