<?php
require_once __DIR__ . '/../_init.php';
admin_require_login();
$cfg = app_config();
$admin = admin_current();
$active = $active ?? '';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title><?php echo htmlspecialchars($cfg['APP_NAME']); ?> Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="../assets/css/admin.css" rel="stylesheet">
</head>
<body>
<div class="sidebar">
  <div class="brand"><?php echo htmlspecialchars($cfg['APP_NAME']); ?> Admin</div>
  <a class="<?php echo $active==='dashboard'?'active':''; ?>" href="dashboard.php">Dashboard</a>
  <a class="<?php echo $active==='vendors'?'active':''; ?>" href="vendors.php">Vendors</a>
  <a class="<?php echo $active==='leads'?'active':''; ?>" href="leads.php">Leads</a>
  <a class="<?php echo $active==='jobs'?'active':''; ?>" href="jobs.php">Jobs</a>
  <a class="<?php echo $active==='tx'?'active':''; ?>" href="transactions.php">Transactions</a>
  <a href="logout.php">Logout</a>
</div>
<div class="main">
  <div class="topbar d-flex justify-content-between align-items-center">
    <div class="fw-semibold"><?php echo htmlspecialchars($active ?: 'Admin'); ?></div>
    <div class="small text-muted">Signed in as <?php echo htmlspecialchars($admin['email'] ?? ''); ?></div>
  </div>
  <div class="container-fluid p-4">
