<?php
$active = 'jobs';
require_once __DIR__ . '/partials/top.php';
$pdo = db();

$status = $_GET['status'] ?? '';
$vendor_id = (int)($_GET['vendor_id'] ?? 0);

$where = [];
$params = [];
if ($status !== '') { $where[] = "j.status=?"; $params[] = $status; }
if ($vendor_id) { $where[] = "j.vendor_id=?"; $params[] = $vendor_id; }

$sql = "SELECT j.*, v.vendor_code, v.name vendor_name, l.title lead_title, l.location, l.time_slot, l.lead_price
        FROM jobs j
        JOIN vendors v ON v.id=j.vendor_id
        JOIN leads l ON l.id=j.lead_id";
if ($where) $sql .= " WHERE " . implode(" AND ", $where);
$sql .= " ORDER BY j.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$jobs = $stmt->fetchAll();

function b($s){
  $map=['accepted'=>'warning','in_progress'=>'primary','completed'=>'success','cancelled'=>'secondary'];
  $c=$map[$s]??'secondary';
  return "<span class='badge text-bg-$c'>$s</span>";
}
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <div>
    <h4 class="fw-bold mb-0">Jobs</h4>
    <div class="text-muted small">Monitor job lifecycle across vendors.</div>
  </div>
</div>

<form class="row g-2 mb-3">
  <div class="col-md-3">
    <label class="form-label small text-muted">Status</label>
    <select class="form-select" name="status">
      <option value="">All</option>
      <?php foreach (['accepted','in_progress','completed','cancelled'] as $s): ?>
        <option value="<?php echo $s; ?>" <?php if ($status===$s) echo 'selected'; ?>><?php echo $s; ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-3">
    <label class="form-label small text-muted">Vendor ID</label>
    <input class="form-control" name="vendor_id" value="<?php echo $vendor_id ?: ''; ?>" placeholder="Optional">
  </div>
  <div class="col-auto d-flex align-items-end">
    <button class="btn btn-outline-dark" type="submit">Filter</button>
  </div>
</form>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle mb-0">
      <thead>
        <tr>
          <th>ID</th>
          <th>Vendor</th>
          <th>Lead</th>
          <th>Time Slot</th>
          <th>Status</th>
          <th>Lead Price</th>
          <th>Earning</th>
          <th>Photos</th>
          <th class="text-end">Timestamps</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($jobs as $j): ?>
          <tr>
            <td class="fw-semibold">#<?php echo (int)$j['id']; ?></td>
            <td><?php echo htmlspecialchars($j['vendor_code']); ?><div class="small text-muted"><?php echo htmlspecialchars($j['vendor_name']); ?></div></td>
            <td><?php echo htmlspecialchars($j['lead_title']); ?><div class="small text-muted"><?php echo htmlspecialchars($j['location']); ?></div></td>
            <td><?php echo htmlspecialchars($j['time_slot']); ?></td>
            <td><?php echo b($j['status']); ?></td>
            <td>₹<?php echo (int)$j['lead_price']; ?></td>
            <td>₹<?php echo (int)$j['earning_amount']; ?></td>
            <td class="small">
              <?php if ($j['before_photo_path']): ?><a target="_blank" href="../<?php echo htmlspecialchars($j['before_photo_path']); ?>">before</a><?php else: ?><span class="text-muted">-</span><?php endif; ?>
              <?php echo " / "; ?>
              <?php if ($j['after_photo_path']): ?><a target="_blank" href="../<?php echo htmlspecialchars($j['after_photo_path']); ?>">after</a><?php else: ?><span class="text-muted">-</span><?php endif; ?>
            </td>
            <td class="text-end small text-muted">
              <div>Created: <?php echo htmlspecialchars($j['created_at']); ?></div>
              <div>Start: <?php echo htmlspecialchars($j['started_at'] ?? '-'); ?></div>
              <div>Complete: <?php echo htmlspecialchars($j['completed_at'] ?? '-'); ?></div>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($jobs)===0): ?>
          <tr><td colspan="9" class="text-muted">No jobs found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/partials/bottom.php'; ?>
