<?php
session_start();
require_once __DIR__ . '/../../config/helpers.php';

function admin_require_login(): void {
    if (!isset($_SESSION['admin_id'])) {
        header('Location: login.php');
        exit;
    }
}

function admin_current(): ?array {
    if (!isset($_SESSION['admin_id'])) return null;
    $pdo = db();
    $stmt = $pdo->prepare("SELECT id, name, email FROM admin_users WHERE id=?");
    $stmt->execute([(int)$_SESSION['admin_id']]);
    return $stmt->fetch() ?: null;
}
