USE utile_vendor_app;

INSERT INTO admin_users (name, email, password_hash) VALUES
('Utile Admin', 'admin@utile.local', '$2y$10$2Hu9XG6dnl1BKRNhTalfZepNllpC1F8nAdB6A7JNcj8qiCVTju2ky'); 
-- password: Admin@123  (bcrypt hash above)

INSERT INTO vendors (vendor_code, name, phone, email, rating, license_number, approval_status, kyc_status, is_active, wallet_balance, total_earnings, total_jobs) VALUES
('VEN001','Demo Vendor Approved','9999999999','demo.vendor@utile.local',4.70,'LIC-UT-0001','approved','approved',1,800,1500,3),
('VEN002','Ravi Sharma','9876543210','ravi@utile.local',4.40,'LIC-UT-0002','pending','submitted',0,150,0,0),
('VEN003','Neha Singh','9123456780','neha@utile.local',4.60,'LIC-UT-0003','approved','approved',1,250,500,1),
('VEN004','Aman Gupta','9988776655','aman@utile.local',4.30,'LIC-UT-0004','rejected','rejected',0,0,0,0);

INSERT INTO vendor_kyc (vendor_id, aadhar_front_path, aadhar_back_path, pan_front_path, pan_back_path, license_photo_path, license_number, status, admin_notes, submitted_at, reviewed_at) VALUES
(1,'uploads/kyc/aadhar_front.jpg','uploads/kyc/aadhar_back.jpg','uploads/kyc/pan_front.jpg','uploads/kyc/pan_back.jpg','uploads/kyc/license.jpg','LIC-UT-0001','approved','All documents verified.','2025-12-10 11:10:00','2025-12-10 18:40:00'),
(2,'uploads/kyc/aadhar_front.jpg','uploads/kyc/aadhar_back.jpg','uploads/kyc/pan_front.jpg','uploads/kyc/pan_back.jpg','uploads/kyc/license.jpg','LIC-UT-0002','submitted','Need clearer PAN image.','2026-01-10 10:05:00',NULL),
(3,'uploads/kyc/aadhar_front.jpg','uploads/kyc/aadhar_back.jpg','uploads/kyc/pan_front.jpg','uploads/kyc/pan_back.jpg','uploads/kyc/license.jpg','LIC-UT-0003','approved','OK.','2026-01-08 09:25:00','2026-01-08 12:10:00'),
(4,'uploads/kyc/aadhar_front.jpg','uploads/kyc/aadhar_back.jpg','uploads/kyc/pan_front.jpg','uploads/kyc/pan_back.jpg','uploads/kyc/license.jpg','LIC-UT-0004','rejected','Mismatch in license number.','2026-01-05 14:20:00','2026-01-06 10:00:00');

INSERT INTO leads (title, customer_name, customer_phone, service_details, time_slot, location, lead_price, is_available) VALUES
('AC Service (Split AC)','Ankit Verma','9000000001','General servicing + cleaning','Today 10:00-12:00','Indore, Vijay Nagar',120,1),
('Salon at Home (Haircut)','Priya Jain','9000000002','Haircut + beard trim','Today 13:00-14:00','Bhopal, MP Nagar',90,1),
('Bathroom Deep Cleaning','Rahul Mehta','9000000003','2 bathrooms deep clean','Tomorrow 09:00-11:00','Delhi, Rohini',150,1),
('Sofa Cleaning','Simran Kaur','9000000004','3-seater + 2 cushions','Tomorrow 16:00-17:00','Gurugram, Sector 56',110,1),
('RO Service','Kunal Shah','9000000005','Filter + membrane check','Today 18:00-19:00','Mumbai, Andheri',80,1),
('Laptop Repair','Isha Patel','9000000006','Keyboard issue + cleanup','Tomorrow 11:00-12:00','Ahmedabad, Navrangpura',140,1),
('Car Wash','Aditi Roy','9000000007','Exterior + interior vacuum','Today 07:00-08:00','Pune, Hinjewadi',70,1),
('Pest Control','Deepak Yadav','9000000008','1 BHK treatment','Tomorrow 14:00-16:00','Lucknow, Gomti Nagar',200,1);

-- Seed wallet transactions
INSERT INTO wallet_transactions (vendor_id, type, amount, description) VALUES
(1,'credit',1000,'Seed wallet credit'),
(1,'debit',120,'Picked lead #1'),
(1,'earning',500,'Job earning credit'),
(3,'credit',300,'Seed wallet credit');

-- Seed jobs
INSERT INTO jobs (vendor_id, lead_id, status, before_photo_path, after_photo_path, completion_otp_entered, earning_amount, started_at, completed_at) VALUES
(1,1,'completed','uploads/jobs/before.jpg','uploads/jobs/after.jpg','5678',500,'2026-01-20 10:10:00','2026-01-20 11:30:00'),
(1,5,'accepted',NULL,NULL,NULL,500,NULL,NULL),
(3,7,'completed','uploads/jobs/before.jpg','uploads/jobs/after.jpg','5678',500,'2026-01-21 07:05:00','2026-01-21 07:50:00');

-- Mark used leads as unavailable where job exists
UPDATE leads SET is_available=0 WHERE id IN (1,7);
